<?php $__env->startSection('title', translate('brand_Add')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">

        <div class="d-flex flex-wrap gap-2 align-items-center mb-3">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/brand.png')); ?>" alt="">
                <?php echo e(translate('brand_Setup')); ?>

            </h2>
        </div>

        <div class="row g-3">
            <div class="col-md-12">
                <div class="card mb-3">
                    <div class="card-body text-start">
                        <form action="<?php echo e(route('admin.brand.add-new')); ?>" method="post" enctype="multipart/form-data" class="brand-setup-form">
                            <?php echo csrf_field(); ?>

                            <ul class="nav nav-tabs w-fit-content mb-4">
                                <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <span class="nav-link form-system-language-tab cursor-pointer <?php echo e($lang == $defaultLanguage ? 'active':''); ?>"
                                           id="<?php echo e($lang); ?>-link">
                                            <?php echo e(ucfirst(getLanguageName($lang)).'('.strtoupper($lang).')'); ?>

                                        </span>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="row">
                                <div class="col-md-6">
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div
                                            class="form-group <?php echo e($lang != $defaultLanguage ? 'd-none':''); ?> form-system-language-form"
                                            id="<?php echo e($lang); ?>-form">
                                            <label for="name" class="title-color">
                                                <?php echo e(translate('brand_Name')); ?>

                                                <span class="text-danger">*</span>
                                                (<?php echo e(strtoupper($lang)); ?>)
                                            </label>
                                            <input type="text" name="name[]" class="form-control" id="name" value=""
                                                   placeholder="<?php echo e(translate('ex')); ?> : <?php echo e(translate('LUX')); ?>" <?php echo e($lang == $defaultLanguage? 'required':''); ?>>
                                        </div>
                                        <input type="hidden" name="lang[]" value="<?php echo e($lang); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="title-color text-capitalize">
                                            <?php echo e(translate('image_alt_text')); ?>

                                        </label>
                                        <input type="text" name="image_alt_text" class="form-control" value=""
                                               placeholder="<?php echo e(translate('ex').' : '.translate('apex_Brand')); ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="card mb-4 shadow-none">
                                <div class="card-body py-5">
                                    <div class="mx-auto text-center max-w-170px">
                                        <label class="d-block text-center font-weight-bold">
                                            <?php echo e(translate('image')); ?>  <small class="text-danger"><?php echo e('('.translate('size').': 1:1)'); ?></small>
                                        </label>

                                        <label class="custom_upload_input d-block mx-2 cursor-pointer">
                                            <input type="file" name="image" id="brand-image" class="image-input image-preview-before-upload d-none" data-preview="#pre_img_viewer" accept="image/*">

                                            <span class="delete_file_input btn btn-outline-danger btn-sm square-btn d--none">
                                                <i class="tio-delete"></i>
                                            </span>

                                            <div class="img_area_with_preview position-absolute z-index-2 p-0">
                                                <img id="pre_img_viewer" class="h-auto aspect-1 bg-white d-none"
                                                        src="dummy" alt="">
                                            </div>
                                            <div class="placeholder-image">
                                                <div
                                                    class="d-flex flex-column justify-content-center align-items-center aspect-1">
                                                    <img alt="" width="33" src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/icons/product-upload-icon.svg')); ?>">
                                                    <h3 class="text-muted fz-12"><?php echo e(translate('Upload_Image')); ?></h3>
                                                </div>
                                            </div>
                                        </label>

                                        <p class="text-muted mt-2 fz-12 m-0">
                                            <?php echo e(translate('image_format')); ?> : <?php echo e("jpg, png, jpeg"); ?>

                                            <br>
                                            <?php echo e(translate('image_size')); ?> : <?php echo e(translate('max')); ?> <?php echo e("2 MB"); ?></p>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex gap-3 justify-content-end">
                                <button type="reset" id="reset"
                                        class="btn btn-secondary px-4"><?php echo e(translate('reset')); ?></button>
                                <button type="submit" class="btn btn--primary px-4"><?php echo e(translate('submit')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $('.brand-setup-form').on('reset', function () {
            $(this).find('#pre_img_viewer').addClass('d-none');
            $(this).find('.placeholder-image').css('opacity', '1');
        });
    </script>
    <script src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/js/products-management.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/sixvelly.nexprism.com/resources/views/admin-views/brand/add-new.blade.php ENDPATH**/ ?>